﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<script runat="server">
    
    DokumentyParams pars;

    [Context]
    public DokumentyParams Pars {
        get { return pars; }
        set { pars = value; }
    }

    Towar towar;

    [Context]
    public Towar Towar {
        get { return towar; }
        set { towar = value; }
    }

    protected void dc_ContextLoading(object sender, EventArgs e) {
        if (!dc.Context.Contains(typeof(DokumentyParams)))
            throw new InvalidOperationException("Raport dostępny po uzupełnieniu parametrów na zakładace pozycji towaru.");
    }

    protected void dc_ContextLoad(object sender, EventArgs e) {
        if (!towar.LiczMagazyn)
            throw new RowException(towar,
                "Dla towaru '{0}' bez obrotów magazynowych wyliczenie raportu nie jest możliwe. Wybierz inny towar z obrotami magazynowymi.",
                towar);
        SubTable st = Towar.Pozycje;
        if (pars.OkresDat != FromTo.All)
            st = new SubTable(st, pars.OkresDat);

        Soneta.Business.View view = st.CreateView();

        pars.AddKierunekSeriaDefinicja(view, "Dokument.", false);
        pars.AddTypPartii(view, "Dokument.");

        if (pars.Magazyn != null)
            view.Condition &= new FieldCondition.Equal("Dokument.Magazyn", pars.Magazyn);

        view.FilterCondition += new ConditionHandler(view_FilterCondition);

        if (!pars.Duplikaty)
            view.Condition &= new FieldCondition.Equal("Dokument.Definicja.DuplikatWartosci", false);

        Grid.DataSource = view;
    }
    private void view_FilterCondition(object sender, ConditionEventArgs args) {
        PozycjaDokHandlowego poz = (PozycjaDokHandlowego)args.Row;
        if (!poz.Dokument.Zatwierdzony) {
            if (poz.Dokument.Definicja.MomentMagazynu != MomentMagazynu.PodczasZapisu)
                args.Accepted = false;
        }
        if (poz.IlośćZasobu.IsZero && !poz.Korekta)
            args.Accepted = false;
    }

</script>
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Pozycje handlowe towaru</title>
		<meta content="C#" name="CODE_LANGUAGE" />
		<meta content="JavaScript" name="vs_defaultClientScript" />
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
	<body>
		<form action="#" method="post" runat="server">
			<ea:DataContext ID="dc" runat="server" TypeName="Soneta.Towary.Towar,Soneta.Handel" OnContextLoad="dc_ContextLoad" OnContextLoading="dc_ContextLoading"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Obroty towaru {0}|Nazwa towaru: {1}|Magazyn: {2}|Okres: {3}" DataMember0="Kod" DataMember1="Nazwa" DataMember2="Context.Magazyn" DataMember3="Context.FromTo" ></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel">
				<Columns>
                    <ea:GridColumn runat="server" Align="Right" Caption="Lp." DataMember="#" Width="4" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Ilość/P" DataMember="Workers.ObrotyPozycji.IlośćPrzychodu" Width="10" Align="Right" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Ilość/R" DataMember="Workers.ObrotyPozycji.IlośćRozchodu"
                        Width="10" Align="Right" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Stan po" DataMember="Workers.ObrotyPozycji.StanPo"
                        Width="10" Align="Right" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Wartość magazynowa" DataMember="Workers.ObrotyPozycji.WartośćMagazynu" Width="13" Align="Right" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Wartość po" DataMember="Workers.ObrotyPozycji.WartośćPo" Width="12" Align="Right" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Dokument/M" DataMember="Workers.ObrotyPozycji.DokumentMagazynowy.Numer" Width="20" Align="Right" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Data/M" DataMember="Workers.ObrotyPozycji.DokumentMagazynowy.Data" Width="10" Align="Right" EncodeHTML="True">
                    </ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Kontrahent/M" DataMember="Workers.ObrotyPozycji.DokumentMagazynowy.Kontrahent" EncodeHTML="True">
                    </ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</form>
	</body>
</html>

